CREATE DATABASE Mikroprodaja;
go
USE Mikroprodaja;
go

CREATE TABLE GrupaProizvoda
(	IDGrupe	int				NOT NULL	IDENTITY (1,1),
	Naziv	nvarchar(100)	NOT NULL,
	CONSTRAINT PK_GrupaProizvoda	PRIMARY KEY(IDGrupe)
)


CREATE TABLE Proizvod
(	IDProizvoda			int		NOT NULL	IDENTITY (1,1),
	Naziv				nvarchar(100)	NOT NULL,
	Cijena				money	NOT NULL,
	GrupaProizvodaID	int		NOT NULL,
	CONSTRAINT PK_Proizvod	
		PRIMARY KEY(IDProizvoda),
	CONSTRAINT FK_GrupaProizvoda_Proizvod	
		FOREIGN KEY (GrupaProizvodaID)	
		REFERENCES GrupaProizvoda(IDGrupe)
)

-----

CREATE TABLE ProdajnoMjesto
(	IDProdajnogMjesta		int		NOT NULL	IDENTITY (1,1),
	Naziv					nvarchar(100)	NOT NULL,
	Adresa					nvarchar(100)	NULL,
	GrupaProizvodaID		int		NOT NULL	
	CONSTRAINT PK_Prodajno_mjesto
		PRIMARY KEY(IDProdajnogMjesta)
	CONSTRAINT FK_Prodajno_mjesto_Grupa_proizvoda
		FOREIGN KEY(GrupaProizvodaID)	REFERENCES	GrupaProizvoda(IDGrupe),
)



CREATE TABLE Zaposlenik
(	
	IDZaposlenika	int				NOT NULL IDENTITY (1,1),
	OIB				char(11)		NOT NULL CONSTRAINT UQ_OIB UNIQUE,
	Ime				nvarchar(100)	NOT NULL,
	Prezime			nvarchar(100)	NOT NULL,
	Adresa			nvarchar(100)	NOT NULL,
	Grad			nvarchar(100)	NOT NULL CONSTRAINT DF_Grad DEFAULT 'Zagreb', 
	God_rod			bigint			NOT NULL CONSTRAINT CH_God_rod CHECK (God_rod>1900),
	Vrijeme_upisa	smalldatetime	NOT NULL CONSTRAINT DF_Vrijeme_upisa DEFAULT GetDate(),
	ID_nadredjenog		int			NULL,
	ProdajnoMjestoID	int			NOT NULL,
	CONSTRAINT	PK_Zaposlenik	
		PRIMARY KEY (IDZaposlenika),
	CONSTRAINT	FK_Nadredjeni	
		FOREIGN KEY (ID_nadredjenog)	REFERENCES Zaposlenik(IDZaposlenika),
	CONSTRAINT	FK_ProdajnoMjesto	
		FOREIGN KEY (ProdajnoMjestoID)	REFERENCES ProdajnoMjesto(IDProdajnogMjesta)
);


---------------------------------------------------

ALTER TABLE Zaposlenik DROP CONSTRAINT DF_Grad

ALTER TABLE Zaposlenik ADD CONSTRAINT DF_Grad DEFAULT 'ZG' FOR Grad 

---------------------------------------------------

ALTER TABLE Zaposlenik DROP CONSTRAINT UQ_OIB
		
ALTER TABLE Zaposlenik ADD CONSTRAINT UQ_OIB UNIQUE (OIB) 

---------------------------------------------------

ALTER TABLE Zaposlenik DROP CONSTRAINT CH_God_rod
	
ALTER TABLE Zaposlenik ADD	CONSTRAINT CH_God_rod CHECK ( God_rod > 1950 AND God_rod < 1995)

---------------------------------------------------